/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.block.entity;

import com.google.common.base.Preconditions;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureServer;
import io.github.mortuusars.exposure.block.LightroomBlock;
import io.github.mortuusars.exposure.block.entity.Lightroom;
import io.github.mortuusars.exposure.camera.infrastructure.FilmType;
import io.github.mortuusars.exposure.item.DevelopedFilmItem;
import io.github.mortuusars.exposure.item.PhotographItem;
import io.github.mortuusars.exposure.item.StackedPhotographsItem;
import io.github.mortuusars.exposure.menu.LightroomMenu;
import io.github.mortuusars.exposure.util.ItemAndStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LightroomBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    public static final int CONTAINER_DATA_SIZE = 3;
    public static final int CONTAINER_DATA_PROGRESS_ID = 0;
    public static final int CONTAINER_DATA_PRINT_TIME_ID = 1;
    public static final int CONTAINER_DATA_SELECTED_FRAME_ID = 2;
    protected final ContainerData containerData = new ContainerData(){

        public int m_6413_(int id) {
            return switch (id) {
                case 0 -> LightroomBlockEntity.this.progress;
                case 1 -> LightroomBlockEntity.this.printTime;
                case 2 -> LightroomBlockEntity.this.getSelectedFrame();
                default -> 0;
            };
        }

        public void m_8050_(int id, int value) {
            if (id == 0) {
                LightroomBlockEntity.this.progress = value;
            } else if (id == 1) {
                LightroomBlockEntity.this.printTime = value;
            } else if (id == 2) {
                LightroomBlockEntity.this.setSelectedFrame(value);
            }
            LightroomBlockEntity.this.m_6596_();
        }

        public int m_6499_() {
            return 3;
        }
    };
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)7, (Object)ItemStack.f_41583_);
    protected int selectedFrame = 0;
    protected int progress = 0;
    protected int printTime = 0;
    protected int printedPhotographsCount = 0;
    protected boolean advanceFrame;

    public LightroomBlockEntity(BlockPos pos, BlockState blockState) {
        super(Exposure.BlockEntityTypes.LIGHTROOM.get(), pos, blockState);
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos blockPos, BlockState blockState, T blockEntity) {
        if (blockEntity instanceof LightroomBlockEntity) {
            LightroomBlockEntity lightroomBlockEntity = (LightroomBlockEntity)blockEntity;
            lightroomBlockEntity.tick();
        }
    }

    protected void tick() {
        if (this.printTime <= 0 || !this.canPrint()) {
            this.stopPrintingProcess();
            return;
        }
        if (this.progress < this.printTime) {
            ++this.progress;
            if (this.progress % 55 == 0 && this.printTime - this.progress > 12 && this.f_58857_ != null) {
                this.f_58857_.m_5594_(null, this.m_58899_(), Exposure.SoundEvents.LIGHTROOM_PRINT.get(), SoundSource.BLOCKS, 1.0f, this.f_58857_.m_213780_().m_188501_() * 0.3f + 1.0f);
            }
            return;
        }
        if (this.tryPrint()) {
            this.onFramePrinted();
        }
        this.stopPrintingProcess();
    }

    protected void onFramePrinted() {
        if (this.advanceFrame) {
            this.advanceFrame();
        }
    }

    protected void advanceFrame() {
        ItemAndStack film = new ItemAndStack(this.m_8020_(0));
        int frames = ((DevelopedFilmItem)film.getItem()).getExposedFramesCount(film.getStack());
        if (this.getSelectedFrame() >= frames - 1) {
            this.tryEjectFilm();
        } else {
            this.setSelectedFrame(this.getSelectedFrame() + 1);
            this.m_6596_();
        }
    }

    public boolean isAdvancingFrameOnPrint() {
        return this.advanceFrame;
    }

    protected boolean tryEjectFilm() {
        Direction facing;
        if (this.f_58857_ == null || this.f_58857_.f_46443_ || this.m_8020_(0).m_41619_()) {
            return false;
        }
        BlockPos pos = this.m_58899_();
        if (this.f_58857_.m_8055_(pos.m_121945_(facing = (Direction)this.f_58857_.m_8055_(pos).m_61143_((Property)LightroomBlock.FACING))).m_60815_()) {
            return false;
        }
        ItemStack filmStack = this.m_7407_(0, 1);
        Vec3i normal = facing.m_122436_();
        Vec3 point = Vec3.m_82512_((Vec3i)pos).m_82520_((double)((float)normal.m_123341_() * 0.75f), (double)((float)normal.m_123342_() * 0.75f), (double)((float)normal.m_123343_() * 0.75f));
        ItemEntity itemEntity = new ItemEntity(this.f_58857_, point.f_82479_, point.f_82480_, point.f_82481_, filmStack);
        itemEntity.m_20334_((double)((float)normal.m_123341_() * 0.05f), (double)((float)normal.m_123342_() * 0.05f + 0.15f), (double)((float)normal.m_123343_() * 0.05f));
        itemEntity.m_32060_();
        this.f_58857_.m_7967_((Entity)itemEntity);
        this.inventoryContentsChanged(0);
        return true;
    }

    public int getSelectedFrame() {
        return this.selectedFrame;
    }

    public void setSelectedFrame(int index) {
        if (this.selectedFrame != index) {
            this.selectedFrame = index;
            this.stopPrintingProcess();
        }
    }

    public void startPrintingProcess(boolean advanceFrame) {
        if (!this.canPrint()) {
            return;
        }
        ItemStack filmStack = this.m_8020_(0);
        Item item = filmStack.m_41720_();
        if (!(item instanceof DevelopedFilmItem)) {
            return;
        }
        DevelopedFilmItem developedFilmItem = (DevelopedFilmItem)item;
        this.printTime = developedFilmItem.getType() == FilmType.COLOR ? (Integer)Config.Common.LIGHTROOM_COLOR_FILM_PRINT_TIME.get() : (Integer)Config.Common.LIGHTROOM_BW_FILM_PRINT_TIME.get();
        this.advanceFrame = advanceFrame;
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)LightroomBlock.LIT, (Comparable)Boolean.valueOf(true)), 2);
            this.f_58857_.m_5594_(null, this.m_58899_(), Exposure.SoundEvents.LIGHTROOM_PRINT.get(), SoundSource.BLOCKS, 1.0f, this.f_58857_.m_213780_().m_188501_() * 0.3f + 1.0f);
        }
    }

    public void stopPrintingProcess() {
        this.progress = 0;
        this.printTime = 0;
        this.advanceFrame = false;
        if (this.f_58857_ != null && this.f_58857_.m_8055_(this.m_58899_()).m_60734_() instanceof LightroomBlock) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.f_58857_.m_8055_(this.m_58899_()).m_61124_((Property)LightroomBlock.LIT, (Comparable)Boolean.valueOf(false)), 2);
        }
    }

    public boolean isPrinting() {
        return this.printTime > 0;
    }

    public boolean canPrint() {
        StackedPhotographsItem stackedPhotographsItem;
        Item item;
        DevelopedFilmItem developedFilm;
        if (this.getSelectedFrame() < 0) {
            return false;
        }
        if (this.m_8020_(1).m_41619_()) {
            return false;
        }
        ItemStack filmStack = this.m_8020_(0);
        Item item2 = filmStack.m_41720_();
        if (!(item2 instanceof DevelopedFilmItem) || !(developedFilm = (DevelopedFilmItem)item2).hasExposedFrame(filmStack, this.getSelectedFrame())) {
            return false;
        }
        if (!this.hasDyesForPrint(developedFilm.getType())) {
            return false;
        }
        ItemStack resultStack = this.m_8020_(6);
        return resultStack.m_41619_() || resultStack.m_41720_() instanceof PhotographItem || (item = resultStack.m_41720_()) instanceof StackedPhotographsItem && (stackedPhotographsItem = (StackedPhotographsItem)item).canAddPhotograph(resultStack);
    }

    public boolean hasDyesForPrint(FilmType type) {
        if (type == FilmType.COLOR) {
            return !this.m_8020_(2).m_41619_() && !this.m_8020_(3).m_41619_() && !this.m_8020_(4).m_41619_() && !this.m_8020_(5).m_41619_();
        }
        if (type == FilmType.BLACK_AND_WHITE) {
            return !this.m_8020_(5).m_41619_();
        }
        LogUtils.getLogger().info("Don't know what dyes needed for the film type: <" + type + ">");
        return false;
    }

    public boolean tryPrint() {
        Preconditions.checkState((this.f_58857_ != null && !this.f_58857_.f_46443_ ? 1 : 0) != 0, (Object)"Cannot be called clientside.");
        if (!this.canPrint()) {
            return false;
        }
        ItemAndStack film = new ItemAndStack(this.m_8020_(0));
        ListTag frames = ((DevelopedFilmItem)film.getItem()).getExposedFrames(film.getStack());
        CompoundTag frameTag = frames.m_128728_(this.getSelectedFrame());
        frameTag.m_128359_("Type", ((DevelopedFilmItem)film.getItem()).getType().m_7912_());
        ItemStack photographStack = new ItemStack((ItemLike)Exposure.Items.PHOTOGRAPH.get());
        photographStack.m_41751_(frameTag);
        ItemStack resultStack = this.m_8020_(6);
        if (resultStack.m_41619_()) {
            resultStack = photographStack;
        } else if (resultStack.m_41720_() instanceof PhotographItem) {
            stackedPhotographsItem = Exposure.Items.STACKED_PHOTOGRAPHS.get();
            ItemStack newStackedPhotographs = new ItemStack((ItemLike)stackedPhotographsItem);
            stackedPhotographsItem.addPhotographOnTop(newStackedPhotographs, resultStack);
            stackedPhotographsItem.addPhotographOnTop(newStackedPhotographs, photographStack);
            resultStack = newStackedPhotographs;
        } else {
            stackedPhotographsItem = resultStack.m_41720_();
            if (stackedPhotographsItem instanceof StackedPhotographsItem) {
                StackedPhotographsItem stackedPhotographsItem = (StackedPhotographsItem)stackedPhotographsItem;
                stackedPhotographsItem.addPhotographOnTop(resultStack, photographStack);
            } else {
                LogUtils.getLogger().error("Unexpected item in result slot: " + resultStack);
                return false;
            }
        }
        this.m_6836_(6, resultStack);
        if (((DevelopedFilmItem)film.getItem()).getType() == FilmType.COLOR) {
            this.m_8020_(2).m_41774_(1);
            this.m_8020_(3).m_41774_(1);
            this.m_8020_(4).m_41774_(1);
        }
        this.m_8020_(5).m_41774_(1);
        this.m_8020_(1).m_41774_(1);
        if (this.f_58857_ != null) {
            this.f_58857_.m_5594_(null, this.m_58899_(), Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get(), SoundSource.PLAYERS, 0.8f, 1.0f);
        }
        ++this.printedPhotographsCount;
        String id = frameTag.m_128461_("Id");
        if (id.length() > 0) {
            ExposureServer.getExposureStorage().getOrQuery(id).ifPresent(exposure -> {
                CompoundTag properties = exposure.getProperties();
                if (!properties.m_128471_("WasPrinted")) {
                    properties.m_128379_("WasPrinted", true);
                    exposure.m_77762_();
                }
            });
        }
        return true;
    }

    public void dropStoredExperience(@Nullable Player player) {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        int xpPerPrint = (Integer)Config.Common.LIGHTROOM_EXPERIENCE_PER_PRINT.get();
        if (xpPerPrint > 0) {
            for (int i = 0; i < this.printedPhotographsCount; ++i) {
                ExperienceOrb.m_147082_((ServerLevel)((ServerLevel)this.f_58857_), (Vec3)(player != null ? player.m_20182_() : Vec3.m_82512_((Vec3i)this.m_58899_())), (int)(xpPerPrint - 1 + this.f_58857_.m_213780_().m_216339_(0, 3)));
            }
        }
        this.printedPhotographsCount = 0;
        this.m_6596_();
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"block.exposure.lightroom");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int containerId, Inventory inventory) {
        return new LightroomMenu(containerId, inventory, this, this.containerData);
    }

    public boolean isItemValidForSlot(int slot, ItemStack stack) {
        if (slot == 0) {
            return stack.m_41720_() instanceof DevelopedFilmItem;
        }
        if (slot == 2) {
            return stack.m_204117_(Exposure.Tags.Items.CYAN_PRINTING_DYES);
        }
        if (slot == 3) {
            return stack.m_204117_(Exposure.Tags.Items.MAGENTA_PRINTING_DYES);
        }
        if (slot == 4) {
            return stack.m_204117_(Exposure.Tags.Items.YELLOW_PRINTING_DYES);
        }
        if (slot == 5) {
            return stack.m_204117_(Exposure.Tags.Items.BLACK_PRINTING_DYES);
        }
        if (slot == 1) {
            return stack.m_204117_(Exposure.Tags.Items.PHOTO_PAPERS);
        }
        if (slot == 6) {
            return stack.m_41720_() instanceof PhotographItem;
        }
        return false;
    }

    protected void inventoryContentsChanged(int slot) {
        if (slot == 0) {
            this.setSelectedFrame(0);
        }
        this.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        return this.f_58857_ != null && this.f_58857_.m_7702_(this.f_58858_) == this && player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    public int @NotNull [] m_7071_(@NotNull Direction face) {
        return Lightroom.ALL_SLOTS;
    }

    public boolean m_7155_(int index, @NotNull ItemStack itemStack, @Nullable Direction direction) {
        if (direction == Direction.DOWN) {
            return false;
        }
        return this.m_7013_(index, itemStack);
    }

    public boolean m_7013_(int index, ItemStack stack) {
        return index != 6 && this.isItemValidForSlot(index, stack) && super.m_7013_(index, stack);
    }

    public boolean m_7157_(int index, @NotNull ItemStack pStack, @NotNull Direction direction) {
        for (int outputSlot : Lightroom.OUTPUT_SLOTS) {
            if (index != outputSlot) continue;
            return true;
        }
        return false;
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
        if (tag.m_128425_("Inventory", 10)) {
            CompoundTag inventory = tag.m_128469_("Inventory");
            ListTag itemsList = inventory.m_128437_("Items", 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                CompoundTag itemTags = itemsList.m_128728_(i);
                int slot = itemTags.m_128451_("Slot");
                if (slot < 0 || slot >= this.items.size()) continue;
                this.items.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
            }
        }
        this.setSelectedFrame(tag.m_128451_("SelectedFrame"));
        this.progress = tag.m_128451_("Progress");
        this.printTime = tag.m_128451_("PrintTime");
        this.printedPhotographsCount = tag.m_128451_("PrintedPhotographsCount");
        this.advanceFrame = tag.m_128471_("AdvanceFrame");
    }

    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        if (this.getSelectedFrame() > 0) {
            tag.m_128405_("SelectedFrame", this.getSelectedFrame());
        }
        if (this.progress > 0) {
            tag.m_128405_("Progress", this.progress);
        }
        if (this.printTime > 0) {
            tag.m_128405_("PrintTime", this.printTime);
        }
        if (this.printedPhotographsCount > 0) {
            tag.m_128405_("PrintedPhotographsCount", this.printedPhotographsCount);
        }
        if (this.advanceFrame) {
            tag.m_128379_("AdvanceFrame", true);
        }
    }

    protected NonNullList<ItemStack> getItems() {
        return this.items;
    }

    public int m_6643_() {
        return 7;
    }

    public boolean m_7983_() {
        return this.getItems().stream().allMatch(ItemStack::m_41619_);
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        return (ItemStack)this.getItems().get(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemStack = ContainerHelper.m_18969_(this.getItems(), (int)slot, (int)amount);
        if (!itemStack.m_41619_()) {
            this.inventoryContentsChanged(slot);
        }
        return itemStack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.getItems(), (int)slot);
    }

    public void m_6836_(int slot, ItemStack stack) {
        this.getItems().set(slot, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.inventoryContentsChanged(slot);
    }

    public void m_6211_() {
        this.getItems().clear();
        this.inventoryContentsChanged(-1);
    }

    public void m_6596_() {
        super.m_6596_();
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

